/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.data;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.data.DataKeyBase;
import icyllis.flexmark.util.data.DataSet;
import icyllis.flexmark.util.data.DataValueFactory;
import icyllis.flexmark.util.data.MutableDataSet;
import icyllis.flexmark.util.data.MutableScopedDataSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ScopedDataSet
extends DataSet {
    protected final DataHolder parent;

    public ScopedDataSet(@Nullable DataHolder parent) {
        this.parent = parent;
    }

    public ScopedDataSet(@Nullable DataHolder parent, @Nullable DataHolder other) {
        super(other);
        this.parent = parent;
    }

    public DataHolder getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Map<? extends DataKeyBase<?>, Object> getAll() {
        if (this.parent != null) {
            HashMap all = new HashMap(this.parent.getAll());
            all.putAll(super.getAll());
            return all;
        }
        return super.getAll();
    }

    @Override
    @NotNull
    public Collection<? extends DataKeyBase<?>> getKeys() {
        if (this.parent != null) {
            HashSet all = new HashSet(this.parent.getKeys());
            all.addAll(super.getKeys());
            return all;
        }
        return super.getKeys();
    }

    @Override
    @NotNull
    public MutableDataSet toMutable() {
        MutableDataSet mutableDataSet = new MutableDataSet();
        mutableDataSet.dataSet.putAll(super.getAll());
        return this.parent != null ? new MutableScopedDataSet(this.parent, mutableDataSet) : mutableDataSet;
    }

    @Override
    public boolean contains(@NotNull DataKeyBase<?> key) {
        return super.contains(key) || this.parent != null && this.parent.contains(key);
    }

    @Override
    @Nullable
    public Object getOrCompute(@NotNull DataKeyBase<?> key, @NotNull DataValueFactory<?> factory) {
        if (this.parent == null || super.contains(key) || !this.parent.contains(key)) {
            return super.getOrCompute(key, factory);
        }
        return this.parent.getOrCompute(key, factory);
    }
}

